@extends('panel.layout.app', ['disable_tblr' => true])
@section('title', __('AI Detector'))
@section('titlebar_subtitle', __('Analyze text, comparing it against a vast database online content to check AI writing'))

@section('content')
    <div class="py-10">
        <div class="lqd-plagiarism-wrap flex flex-wrap justify-between gap-y-5">
            <div class="w-full lg:w-[48%]">
                <form
                    class="flex flex-col gap-5"
                    id="scan_content_form"
                    onsubmit="return sendScanRequest();"
                    enctype="multipart/form-data"
                >
                    <x-card size="xs">
                        <h4 class="my-0">
                            {{ __('Add Content') }}

                            <small
                                class="ms-3 font-normal"
                                id="content_length"
                            >
                                0/5000
                            </small>
                        </h4>
                    </x-card>

                    <x-forms.input
                        class="tinymce h-[600px] border-border"
                        id="content_scan"
                        name="content_scan"
                        rows="20"
                        required
                        type="textarea"
                    />

                    <div
                        class="tinymce hidden h-[600px] overflow-y-scroll rounded-xl border"
                        id="content_result"
                        name="content_result"
                    ></div>

                    <x-button
                        id="scan_btn"
                        size="lg"
                        form="scan_content_form"
                        type="submit"
                        onclick="return sendScanRequest()"
                    >
                        {{ __('Scan for Plagiarism') }}
                    </x-button>
                </form>
            </div>

            <div class="w-full lg:w-[48%] lg:border-s lg:ps-10">
                <div class="flex flex-col items-center">
                    <h3 class="mb-7 text-center">
                        {{ __('AI Content Report') }}
                    </h3>

                    <div class="relative mb-11">
                        <p class="total_percent absolute left-1/2 top-[calc(50%-5px)] m-0 -translate-x-1/2 text-center text-heading-foreground">
                            <span class="text-[23px] font-bold">0</span>%
                            <br>
                            {{ __('Match') }}
                        </p>
                        <div
                            class="relative [&_.apexcharts-legend-text]:!m-0 [&_.apexcharts-legend-text]:!pe-2 [&_.apexcharts-legend-text]:ps-2 [&_.apexcharts-legend-text]:!text-heading-foreground"
                            id="chart-credit"
                        ></div>
                    </div>

                    <div class="scan_results flex w-full flex-col items-start px-3">
                        <p class="my-2">
                            {{ __('Higlighted sentences have the lowest perplexity and were likely generated by AI') }}
                        </p>

                        <div class="my-1 flex items-center gap-2">
                            <span class="size-4 rounded-xl bg-[#D4534A]"></span>
                            <p class="h1_percent m-0">
                                @lang('High Likely') -
                                <span>0</span>%
                            </p>
                        </div>
                        <div class="my-1 flex items-center gap-2">
                            <span class="size-4 rounded-xl bg-[#E0BE54]"></span>
                            <p class="h2_percent m-0">
                                @lang('Likely') -
                                <span>0</span>%
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <template id="result_template">
        <div class="lqd-plagiarism-result-item flex rounded-2xl px-4 shadow-lg shadow-black/5 dark:shadow-white/[2%]">
            <div class="flex w-4/5 items-center justify-start gap-2 py-4">
                <p class="result_index size-6 m-0 inline-flex shrink-0 items-center justify-center rounded-full bg-heading-foreground/10 text-xs font-medium text-heading-foreground">
                    1
                </p>
                <a
                    class="result_url flex w-full items-center gap-2 truncate text-xs"
                    href="#"
                    target="_blank"
                >
                    <x-tabler-link class="size-4" />
                    <span class="result_url_p">
                        https://themeforest.net/item/...
                    </span>
                </a>
            </div>
            <div class="w-1/5 border-s py-4 text-center">
                <p class="m-0 text-2xs font-medium">{{ __('Match') }}</p>
                <p class="result_percent m-0 text-xs font-bold text-red-500">52%</p>
            </div>
        </div>
    </template>

    <template>
        <span class="hover:bg-red-50">Hello</span>
    </template>

    <div
        class="absolute"
        id="contextMenu"
    >
        <ul class="dropdown-menu block w-[250px] rounded-md border-none p-2 shadow-md">
            <li
                class="flex items-center justify-start p-2 hover:opacity-80"
                id="updateWriting"
            >
                <x-tabler-checks class="size-4" />
                <p class="mx-2 my-0">
                    {{ __('Update Content') }}
                </p>
            </li>
        </ul>
    </div>
@endsection

@push('script')
    <script>
        var total_percent = 0;
        var chart = undefined;

        function renderChart(percent1, percent2) {
            const options = {
                series: [percent1, percent2, 100 - percent1 - percent2],
                labels: [('High likely'), ('Likely'), ('Human Writing')],
                colors: ['#D4534A', '#E0BE54', '#1CA685'],
                chart: {
                    type: 'donut',
                    height: 205,
                },
                legend: {
                    position: 'bottom',
                    fontFamily: 'inherit',
                },
                plotOptions: {
                    pie: {
                        startAngle: -90,
                        endAngle: 90,
                        offsetY: 0,
                        donut: {
                            size: '75%',
                        }
                    },
                },
                grid: {
                    padding: {
                        bottom: -130
                    }
                },
                stroke: {
                    width: 5,
                    colors: 'var(--tblr-body-bg)'
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 280,
                            height: 250
                        },
                    }
                }],
                dataLabels: {
                    enabled: false,
                }
            };
            if (chart) {
                chart.updateSeries([percent1, percent2, 100 - percent1 - percent2]);
            } else {
                chart = (new ApexCharts(document.getElementById('chart-credit'), options));
                chart.render();
            }
        }

        document.addEventListener("DOMContentLoaded", function() {
            "use strict";
            renderChart(0, 0);

        });
    </script>

    <script src="/themes/default/assets/libs/apexcharts/dist/apexcharts.min.js"></script>
    <script>
        var $contextMenu = $("#contextMenu");
        var selectedSentence = undefined;
        $contextMenu.hide();
        $("#content_scan").on('input', function(e) {
            $("#content_length").text($(this).val().length + "/5000");
        })
        $("body").on("contextmenu", ".sentence", function(e) {
            selectedSentence = $(this);
            $contextMenu.css({
                display: "block"
            });
            $contextMenu.css({
                display: "fixed",
                left: e.pageX,
                top: e.pageY
            });
            return false;
        });

        $('html').click(function() {
            $contextMenu.hide();
        });

        $("#updateWriting").click(function(e) {
            let formData = new FormData();
            formData.append('prompt',
                'Rewrite below content unique as human. Keep <br>s');
            formData.append('content', selectedSentence.html());
            document.querySelector('#app-loading-indicator')?.classList?.remove('opacity-0');
            $.ajax({
                type: "post",
                url: "/dashboard/user/openai/update-writing",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    selectedSentence.html(data.result);
                    selectedSentence.contents().unwrap();
                    Alpine.store('appLoadingIndicator').hide();
                },
                error: function(data) {
                    Alpine.store('appLoadingIndicator').hide();
                }
            });
        });
    </script>
    <script>
        function sendScanRequest(ev) {
            "use strict";
            ev?.preventDefault();

            if ($("#content_scan").val().length < 80) {
                toastr.warning('The length of content should be bigger than 80 characters.');
                return false;
            }

            var formData = new FormData();

            formData.append('text', $("#content_scan").val());

            Alpine.store('appLoadingIndicator').show();
            $('#scan_btn').prop('disabled', true);

            $.ajax({
                type: "post",
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}",
                },
                url: "/dashboard/user/openai/aicontentcheck",
                data: formData,
                contentType: false,
                processData: false,
                success: function(data) {
                    $('#scan_btn').prop('disabled', false);
                    Alpine.store('appLoadingIndicator').hide();
                    let chunks = data.data.chunks;

                    let colors = ['#D4534A80', '#E0BE5480', '#1CA68580']
                    let percent1 = data.data.strong_percent;
                    let percent2 = data.data.likely_percent;

                    if (percent1 == null) percent1 = 0;
                    if (percent2 == null) percent2 = 0;

                    $(".h1_percent span").text(percent1);
                    $(".h2_percent span").text(percent2);

                    renderChart(Number(percent1), Number(percent2));
                    $(".total_percent span").text((0 + Number(percent1) + Number(percent2)));
                    let nodes = data.data.chunks;

                    let content = $("#content_scan").val();

                    let reContent = "";

                    let st = 0;

                    for (let i = 0; i < nodes.length; i++) {
                        let tColor = colors[2];
                        reContent += (
                            "<span class='sentence hover:opacity-80 cursor-pointer' style='background-color: " +
                            tColor +
                            "'>" +
                            " " + content.substring(st, nodes[i].position[0]).replace(/\n/g, "<br>") +
                            '</span>');
                        if (nodes[i].reliability == 1) {
                            tColor = colors[1];
                        } else if (nodes[i].reliability == 2) {
                            tColor = colors[0];
                        }
                        reContent += (
                            "<span class='sentence hover:opacity-80 cursor-pointer' style='background-color: " +
                            tColor +
                            "'>" +
                            " " + content.substring(nodes[i].position[0], nodes[i].position[1]).replace(
                                /\n/g, "<br>") +
                            '</span>');
                        console.log(content.substring(nodes[i].position[0], nodes[i].position[1]));
                        st = nodes[i].position[1];
                    }
                    reContent += content.substring(st, content.length).replace(/\n/g, "<br>");
                    console.log(reContent);
                    $("#content_result").removeClass('hidden');
                    $("#content_result").html(reContent);
                    $("#content_scan").hide();
                    var $contextMenu = $("#contextMenu");
                    $("body").on("contextmenu", ".sentence", function(e) {
                        $contextMenu.css({
                            display: "block"
                        });
                        $contextMenu.css({
                            display: "absolute",
                            left: e.pageX,
                            top: e.pageY
                        });
                        return false;
                    });

                    var formData_ = new FormData();

                    formData_.append('input', $("#content_scan").val());
                    formData_.append('percent', Number(percent1) + Number(percent2));
                    formData_.append('text', reContent);

                    $.ajax({
                        type: "post",
                        headers: {
                            'X-CSRF-TOKEN': "{{ csrf_token() }}",
                        },
                        url: "/dashboard/user/openai/aicontentsave",
                        data: formData_,
                        contentType: false,
                        processData: false,
                        success: function() {

                        }
                    });
                },
                error: function(data) {
                    toastr.warning(data.responseJSON.message);
                    console.log(data);
                    Alpine.store('appLoadingIndicator').hide();
                    $('#scan_btn').prop('disabled', false);
                }
            });
            return false;
        }
    </script>
@endpush
